//package globalExamples;

import oracle.olapi.data.source.DataProvider;
import oracle.olapi.data.source.FundamentalMetadataProvider;
import oracle.olapi.data.source.FundamentalMetadataObject;
import oracle.olapi.data.source.Source;
import oracle.olapi.data.source.StringSource;

import oracle.olapi.metadata.mdm.MdmCustomObjectFactory;
import oracle.olapi.metadata.mdm.MdmHierarchy;
import oracle.olapi.metadata.mdm.MdmMeasure;
import oracle.olapi.metadata.mdm.MdmMetadataProvider;
import oracle.olapi.metadata.mdm.MdmPrimaryDimension;

import oracle.olapi.metadata.mtm.MtmCustomExpression;
import oracle.olapi.metadata.mtm.MtmMeasureMap;
import oracle.olapi.metadata.mtm.MtmPartitionedCube;

import java.util.List;
import java.util.Iterator;

/**
 * Complete code for Example 5-4, Creating A Custom Measure, in Chapter 5,
 * Working with Metadata Mapping Objects, in the Oracle OLAP Developer's
 * Guide to the OLAP API.
 *
 * This program uses the Context10g class, which uses the
 * CursorPrintWriter class.
 *
 * @author Oracle Corporation
 */
public class CreatingCustomMeasure
{
  public CreatingCustomMeasure()
  {
  }

  public void run(String [] args)
  {
    Context10g context = new Context10g(args, false);

    context.println("Example 5-4, Creating A Custom Measure\n");

    DataProvider dp = context.getDataProvider();
    MdmMetadataProvider mp = context.getMetadataProvider();

    MdmMeasure mdmUnitPrice = context.getMdmMeasureByName("UNIT_PRICE");
    Source unitPrice = mdmUnitPrice.getSource();

    MdmMeasure mdmUnitCost = context.getMdmMeasureByName("UNIT_COST");
    Source unitCost = mdmUnitCost.getSource();

    // The following appears in the example.
    MtmMeasureMap mtmUnitPriceMap = mdmUnitPrice.getMeasureMap();
    MtmPartitionedCube mtmUnitPricePartCube = (MtmPartitionedCube)
                                               mtmUnitPriceMap.getCube();
    MdmCustomObjectFactory mdmCustObjFactory = mp.getMdmCustomObjectFactory();
    FundamentalMetadataProvider fdp = dp.getFundamentalMetadataProvider();
    FundamentalMetadataObject numberFMO = fdp.getNumberDataType();
    MtmCustomExpression mtmCustExp =
          mdmCustObjFactory.createCustomExpression("UNIT_PRICE - UNIT_COST",
                                                     numberFMO);
    MdmMeasure mdmCustMeasure =
              mdmCustObjFactory.createNumericMeasure("MARKUP",
                                                      mtmUnitPricePartCube,
                                                      mtmCustExp);
    // End of the code appearing in the example.

    // The following gets the dimensions for the UNIT_PRICE, UNIT_COST, and
    // MARKUP measures, creates Source objects for the default hierarchies
    // of the dimensions, selects values from the hierarchies, creates a
    // query that gets the data values of the measures for the dimension
    // selections, and displays the results of the query.

    MdmPrimaryDimension[] mdmPrimDims =
           context.getMdmPrimaryDimensionsByName(new String[] {"CUSTOMER",
                                                               "PRODUCT",
                                                               "CHANNEL",
                                                               "TIME"});

    MdmPrimaryDimension mdmCustPrimDim = mdmPrimDims[0];
    MdmPrimaryDimension mdmProdPrimDim = mdmPrimDims[1];
    MdmPrimaryDimension mdmChanPrimDim = mdmPrimDims[2];
    MdmPrimaryDimension mdmTimePrimDim = mdmPrimDims[3];

    MdmHierarchy mdmCustDefHier = mdmCustPrimDim.getDefaultHierarchy();
    StringSource custDefHier = (StringSource) mdmCustDefHier.getSource();

    MdmHierarchy mdmProdDefHier = mdmProdPrimDim.getDefaultHierarchy();
    StringSource prodDefHier = (StringSource) mdmProdDefHier.getSource();

    MdmHierarchy mdmChanDefHier = mdmChanPrimDim.getDefaultHierarchy();
    StringSource chanDefHier = (StringSource) mdmChanDefHier.getSource();

    MdmHierarchy mdmTimeDefHier = mdmTimePrimDim.getDefaultHierarchy();
    StringSource timeDefHier = (StringSource) mdmTimeDefHier.getSource();

    Source prodSel = prodDefHier.selectValue("PRODUCT_ROLLUP::ITEM::13");
    Source timeSel = timeDefHier.selectValues(new String[]
                                              {"CALENDAR::MONTH::43",
                                               "CALENDAR::MONTH::44",
                                               "CALENDAR::MONTH::45",
                                              });

    Source unitMarkup = mdmCustMeasure.getSource();
    Source measDim = dp.createListSource(new Source[] {unitPrice,
                                                       unitCost,
                                                       unitMarkup});

    Source result = measDim.extract()
                           .join(measDim)
                           .join(prodSel)
                           .join(timeSel);
    context.commit();
    context.displayResult(result);

  }

  public static void main(String[] args)
  {
    new CreatingCustomMeasure().run(args);
  }
}
